//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using CSCashSales.data_objects;

namespace CSCashSales.user_interface
{
  /// <summary>
  /// Cash Sale form.
  /// </summary>
  /// <TgData>
  /// </TgData>
  public class CashForm : System.Windows.Forms.Form
  {
    /// <summary>
    ///    Required designer variable.
    /// </summary>
    private System.ComponentModel.Container components;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.TextBox m_txtChange;
		private System.Windows.Forms.Label m_lblChange;
		private System.Windows.Forms.TextBox m_txtPayment;
		private System.Windows.Forms.Button m_btnPayment;
		private System.Windows.Forms.TextBox m_txtTotal;
		private System.Windows.Forms.Button m_btnTotal;
		private System.Windows.Forms.TextBox m_txtTax;
		private System.Windows.Forms.Label m_lblTax;
		private System.Windows.Forms.TextBox m_txtSubTotal;
		private System.Windows.Forms.Label m_lblSubTotal;
		private System.Windows.Forms.ListView m_lvwData;
		private System.Windows.Forms.TextBox m_txtScanData;
		private System.Windows.Forms.Button m_btnScan;
		private System.Windows.Forms.Button m_btnCancel;
		private System.Windows.Forms.Button m_btnNew;
		private System.Windows.Forms.GroupBox m_gbxData;
		private System.Windows.Forms.MenuItem m_mniAbout;
		private System.Windows.Forms.MenuItem m_mniListSales;
		private System.Windows.Forms.MenuItem m_mniExit;
		private System.Windows.Forms.MenuItem m_mniHelp;
		private System.Windows.Forms.MenuItem m_mniView;
		private System.Windows.Forms.MenuItem m_mniFile;
		private System.Windows.Forms.MainMenu m_mnuMain;

		/// <summary>
		/// A reference to the product container.
		/// </summary>
		private ProductContainer m_objProducts;

		/// <summary>
		/// A reference to the cash sale container.
		/// </summary>
		private CashSaleContainer m_objSaleBag;

		/// <summary>
		/// Current cash sale.
		/// </summary>
		private CashSale m_objCurrentSale;

		/// <summary>
		/// Constructor.
		/// </summary>
        public CashForm()
        {
          //
          // Required for Windows Form Designer support
          //
          InitializeComponent();

          //
          // TODO: Add any constructor code after InitializeComponent call
          //
			    m_objProducts = new ProductContainer();
			    m_objSaleBag = new CashSaleContainer();
			    m_objCurrentSale = null;

			    setupEnableControls();
        }

      /// <summary>
      ///    Clean up any resources being used.
      /// </summary>
      protected override void Dispose( bool disposing )
      {
        if( disposing )
        {
          if(components != null)
          {
            components.Dispose();
          }
        }
        base.Dispose( disposing );
      }

        /// <summary>
        ///    Required method for Designer support - do not modify
        ///    the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container ();
			this.m_btnPayment = new System.Windows.Forms.Button ();
			this.m_mniHelp = new System.Windows.Forms.MenuItem ();
			this.m_txtChange = new System.Windows.Forms.TextBox ();
			this.m_txtTotal = new System.Windows.Forms.TextBox ();
			this.m_txtScanData = new System.Windows.Forms.TextBox ();
			this.m_mniListSales = new System.Windows.Forms.MenuItem ();
			this.m_mnuMain = new System.Windows.Forms.MainMenu ();
			this.m_lblChange = new System.Windows.Forms.Label ();
			this.m_lblTax = new System.Windows.Forms.Label ();
			this.m_mniFile = new System.Windows.Forms.MenuItem ();
			this.m_txtPayment = new System.Windows.Forms.TextBox ();
			this.m_mniView = new System.Windows.Forms.MenuItem ();
			this.m_gbxData = new System.Windows.Forms.GroupBox ();
			this.m_lblSubTotal = new System.Windows.Forms.Label ();
			this.m_lvwData = new System.Windows.Forms.ListView ();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader ();
			this.m_txtTax = new System.Windows.Forms.TextBox ();
			this.m_btnCancel = new System.Windows.Forms.Button ();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader ();
			this.m_btnNew = new System.Windows.Forms.Button ();
			this.m_btnScan = new System.Windows.Forms.Button ();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader ();
			this.m_txtSubTotal = new System.Windows.Forms.TextBox ();
			this.m_mniExit = new System.Windows.Forms.MenuItem ();
			this.m_btnTotal = new System.Windows.Forms.Button ();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader ();
			this.m_mniAbout = new System.Windows.Forms.MenuItem ();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader ();
			//@this.TrayHeight = 90;
			//@this.TrayLargeIcon = false;
			//@this.TrayAutoArrange = true;
			m_btnPayment.Location = new System.Drawing.Point (280, 288);
			m_btnPayment.Size = new System.Drawing.Size (75, 23);
			m_btnPayment.TabIndex = 7;
			m_btnPayment.Text = "Payment";
			m_btnPayment.Click += new System.EventHandler (this.m_btnPayment_Click);
			m_mniHelp.Text = "&Help";
			m_mniHelp.Index = 2;
			//m_mniHelp.MenuItems.All = new System.Windows.Forms.MenuItem[1] {this.m_mniAbout};
			m_mniHelp.MenuItems.Add(0, this.m_mniAbout);
			m_txtChange.Location = new System.Drawing.Point (368, 320);
			m_txtChange.TabIndex = 10;
			m_txtChange.Size = new System.Drawing.Size (100, 20);
			m_txtChange.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_txtTotal.Location = new System.Drawing.Point (368, 256);
			m_txtTotal.TabIndex = 6;
			m_txtTotal.Size = new System.Drawing.Size (100, 20);
			m_txtTotal.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_txtScanData.Location = new System.Drawing.Point (96, 48);
			m_txtScanData.TabIndex = 3;
			m_txtScanData.Size = new System.Drawing.Size (352, 20);
			m_mniListSales.Text = "&List Sales...";
			m_mniListSales.Index = 0;
			m_mniListSales.Click += new System.EventHandler (this.m_mniListSales_Click);
			//@m_mnuMain.SetLocation (new System.Drawing.Point (7, 7));
			//m_mnuMain.MenuItems.All = new System.Windows.Forms.MenuItem[3] {this.m_mniFile, this.m_mniView, this.m_mniHelp};
			m_mnuMain.MenuItems.Add(0,this.m_mniFile);
			m_mnuMain.MenuItems.Add(1,this.m_mniView);
			m_mnuMain.MenuItems.Add(2,this.m_mniHelp);
			m_lblChange.Location = new System.Drawing.Point (312, 320);
			m_lblChange.Text = "Change";
			m_lblChange.Size = new System.Drawing.Size (48, 16);
			m_lblChange.TabIndex = 9;
			m_lblTax.Location = new System.Drawing.Point (328, 232);
			m_lblTax.Text = "Tax";
			m_lblTax.Size = new System.Drawing.Size (24, 16);
			m_lblTax.TabIndex = 3;
			m_mniFile.Text = "&File";
			m_mniFile.Index = 0;
			//m_mniFile.MenuItems.All = new System.Windows.Forms.MenuItem[1] {this.m_mniExit};
			m_mniFile.MenuItems.Add(0,this.m_mniExit);
			m_txtPayment.Location = new System.Drawing.Point (368, 288);
			m_txtPayment.TabIndex = 8;
			m_txtPayment.Size = new System.Drawing.Size (100, 20);
			m_txtPayment.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_mniView.Text = "&View";
			m_mniView.Index = 1;
			//m_mniView.MenuItems.All = new System.Windows.Forms.MenuItem[1] {this.m_mniListSales};
			m_mniView.MenuItems.Add(0,this.m_mniListSales);
			m_gbxData.Location = new System.Drawing.Point (8, 8);
			m_gbxData.TabIndex = 0;
			m_gbxData.TabStop = false;
			m_gbxData.Size = new System.Drawing.Size (464, 192);
			m_lblSubTotal.Location = new System.Drawing.Point (312, 208);
			m_lblSubTotal.Text = "Subtotal";
			m_lblSubTotal.Size = new System.Drawing.Size (48, 16);
			m_lblSubTotal.TabIndex = 1;
			m_lvwData.Location = new System.Drawing.Point (8, 80);
			m_lvwData.Size = new System.Drawing.Size (448, 97);
			//m_lvwData.View = System.Windows.Forms.View.Report;
			m_lvwData.View = System.Windows.Forms.View.Details;
			m_lvwData.ForeColor = System.Drawing.SystemColors.WindowText;
			m_lvwData.GridLines = true;
			m_lvwData.TabIndex = 4;
			//m_lvwData.Columns.All = new System.Windows.Forms.ColumnHeader[5] {this.columnHeader1, this.columnHeader2, this.columnHeader3, this.columnHeader4, this.columnHeader5};
			m_lvwData.Columns.Add(this.columnHeader1);
			m_lvwData.Columns.Add(this.columnHeader2);
			m_lvwData.Columns.Add(this.columnHeader3);
			m_lvwData.Columns.Add(this.columnHeader4);
			m_lvwData.Columns.Add(this.columnHeader5);
			columnHeader3.Text = "Unit";
			columnHeader3.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
			m_txtTax.Location = new System.Drawing.Point (368, 232);
			m_txtTax.TabIndex = 4;
			m_txtTax.Size = new System.Drawing.Size (100, 20);
			m_txtTax.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_btnCancel.Location = new System.Drawing.Point (96, 16);
			m_btnCancel.Size = new System.Drawing.Size (75, 23);
			m_btnCancel.TabIndex = 1;
			m_btnCancel.Text = "&Cancel";
			m_btnCancel.Click += new System.EventHandler (this.m_btnCancel_Click);
			columnHeader1.Text = "Item";
			columnHeader1.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
			m_btnNew.Location = new System.Drawing.Point (8, 16);
			m_btnNew.Size = new System.Drawing.Size (75, 23);
			m_btnNew.TabIndex = 0;
			m_btnNew.Text = "&New Sale";
			m_btnNew.Click += new System.EventHandler (this.m_btnNew_Click);
			m_btnScan.Location = new System.Drawing.Point (8, 48);
			m_btnScan.Size = new System.Drawing.Size (75, 23);
			m_btnScan.TabIndex = 2;
			m_btnScan.Text = "&Scan";
			m_btnScan.Click += new System.EventHandler (this.m_btnScan_Click);
			columnHeader2.Text = "Name";
			columnHeader2.Width = 153;
			columnHeader2.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
			m_txtSubTotal.Location = new System.Drawing.Point (368, 208);
			m_txtSubTotal.TabIndex = 2;
			m_txtSubTotal.Size = new System.Drawing.Size (100, 20);
			m_txtSubTotal.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_mniExit.Text = "E&xit";
			m_mniExit.Index = 0;
			m_mniExit.Click += new System.EventHandler (this.m_mniExit_Click);
			m_btnTotal.Location = new System.Drawing.Point (280, 256);
			m_btnTotal.Size = new System.Drawing.Size (75, 23);
			m_btnTotal.TabIndex = 5;
			m_btnTotal.Text = "Total";
			m_btnTotal.Click += new System.EventHandler (this.m_btnTotal_Click);
			columnHeader4.Text = "Quantity";
			columnHeader4.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			m_mniAbout.Text = "&About";
			m_mniAbout.Index = 0;
			m_mniAbout.Click += new System.EventHandler (this.m_mniAbout_Click);
			columnHeader5.Text = "Price";
			columnHeader5.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.Text = "C# Cash";
			this.AutoScaleBaseSize = new System.Drawing.Size (5, 13);
			this.Menu = this.m_mnuMain;
			this.ClientSize = new System.Drawing.Size (480, 357);
			this.Controls.Add (this.m_txtChange);
			this.Controls.Add (this.m_lblChange);
			this.Controls.Add (this.m_txtPayment);
			this.Controls.Add (this.m_btnPayment);
			this.Controls.Add (this.m_txtTotal);
			this.Controls.Add (this.m_btnTotal);
			this.Controls.Add (this.m_txtTax);
			this.Controls.Add (this.m_lblTax);
			this.Controls.Add (this.m_txtSubTotal);
			this.Controls.Add (this.m_lblSubTotal);
			this.Controls.Add (this.m_gbxData);
			m_gbxData.Controls.Add (this.m_lvwData);
			m_gbxData.Controls.Add (this.m_txtScanData);
			m_gbxData.Controls.Add (this.m_btnScan);
			m_gbxData.Controls.Add (this.m_btnCancel);
			m_gbxData.Controls.Add (this.m_btnNew);
		}

		/// <summary>
		/// An event handler of Payment button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnPayment_Click (object sender, System.EventArgs e)
		{
			doPayment();
		}

		/// <summary>
		/// An event handler of Total button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnTotal_Click (object sender, System.EventArgs e)
		{
			doTotal();
		}

		/// <summary>
		/// An event handler of Scan button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnScan_Click (object sender, System.EventArgs e)
		{
			doScan();
		}

		/// <summary>
		/// An event handler of Cancel button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnCancel_Click (object sender, System.EventArgs e)
		{
			doCancel();
		}

		/// <summary>
		/// An event handler of New Sale button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnNew_Click (object sender, System.EventArgs e)
		{
			doNew();
		}

		/// <summary>
		/// An event handler of Help->About menu item.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_mniAbout_Click (object sender, System.EventArgs e)
		{
			doAbout();
		}

		/// <summary>
		/// An event handler of View->List All Sales menu item.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_mniListSales_Click (object sender, System.EventArgs e)
		{
			doListSales();
		}

		/// <summary>
		/// An event handler of File->Exit menu item.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_mniExit_Click (object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Indicates whether the payment operation can be performed.
		/// </summary>
		private bool canDoPayment() 
		{
			bool result = false;
			if(m_objCurrentSale != null)
				result = m_objCurrentSale.isPaymentAvailable();
			return result;
		}

		/// <summary>
		/// Indicates whether the total operation can be performed.
		/// </summary>
		private bool canDoTotal()
		{
			bool result = false;
			if(m_objCurrentSale != null)
				result = m_objCurrentSale.isTotalAvailable();
			return result;
		}

		/// <summary>
		/// Indicates whether the scan operation can be performed.
		/// </summary>
		private bool canDoScan()
		{
			bool result = m_objCurrentSale != null;
			if(m_objCurrentSale != null)
				result = !m_objCurrentSale.hasTotal();
			return result;
		}

		/// <summary>
		/// Indicates whether the cancel operation can be performed.
		/// </summary>
		private bool canDoCancel()
		{
			bool result = m_objCurrentSale != null;
			return result;
		}

		/// <summary>
		/// Indicates whether the new sale operation can be performed.
		/// </summary>
		private bool canDoNew()
		{
			bool result = true;
			return result;
		}

		/// <summary>
		/// Sets enabled/disabled status of controls.
		/// </summary>
		private void setupEnableControls() 
		{
			m_btnPayment.Enabled = canDoPayment();
			m_btnTotal.Enabled = canDoTotal();
			m_btnScan.Enabled = canDoScan();
			m_btnCancel.Enabled = canDoCancel();
			m_btnNew.Enabled = canDoNew();
		}

		/// <summary>
		/// Updates control contents.
		/// </summary>
		private void refreshControls() 
		{
			refreshControls(false);
		}

		/// <summary>
		/// Updates control contents.
		/// </summary>
		/// <param name="blnTotal"> a flag to update total section. </param>
		private void refreshControls( bool blnTotal ) 
		{
			//m_lvwData.ListItems.Clear();
			m_lvwData.Items.Clear();
			if(m_objCurrentSale != null)
			{
				for(int row=0; row < m_objCurrentSale.getTableRowCount(); row++)
				{
					/*
					ListItem item = m_lvwData.InsertItem( row, m_objCurrentSale.getTableAttrValue( CashSale.ATTR_ITEM, row ) );
					item.SetSubItem( 0, m_objCurrentSale.getTableAttrValue( CashSale.ATTR_NAME, row ) );
					item.SetSubItem( 1, m_objCurrentSale.getTableAttrValue( CashSale.ATTR_UNIT, row ) );
					item.SetSubItem( 2, m_objCurrentSale.getTableAttrValue( CashSale.ATTR_QUANTITY, row ) );
					item.SetSubItem( 3, m_objCurrentSale.getTableAttrValue( CashSale.ATTR_PRICE, row ) );
					*/
					ListViewItem item = m_lvwData.Items.Add(m_objCurrentSale.getTableAttrValue( CashSale.ATTR_ITEM, row ));
					item.SubItems.Add( m_objCurrentSale.getTableAttrValue( CashSale.ATTR_NAME, row ) );
					item.SubItems.Add( m_objCurrentSale.getTableAttrValue( CashSale.ATTR_UNIT, row ) );
					item.SubItems.Add( m_objCurrentSale.getTableAttrValue( CashSale.ATTR_QUANTITY, row ) );
					item.SubItems.Add( m_objCurrentSale.getTableAttrValue( CashSale.ATTR_PRICE, row ) );
					m_txtScanData.Text	= m_objCurrentSale.getTableAttrValue( CashSale.ATTR_NAME, row );
				}
				if(blnTotal)
				{
					m_txtPayment.Text	= m_objCurrentSale.getLinearAttrValue( CashSale.LATTR_PAYMENT );
					m_txtChange.Text	= m_objCurrentSale.getLinearAttrValue( CashSale.LATTR_CHANGE );
					m_txtTax.Text		= m_objCurrentSale.getLinearAttrValue( CashSale.LATTR_TAX );
					m_txtSubTotal.Text  = m_objCurrentSale.getLinearAttrValue( CashSale.LATTR_SUBTOTAL );
					m_txtTotal.Text		= m_objCurrentSale.getLinearAttrValue( CashSale.LATTR_TOTAL );
				}
			}
			else 
			{
				m_txtPayment.Text	= "";
				m_txtChange.Text	= "";
				m_txtTax.Text		= "";
				m_txtSubTotal.Text  = "";
				m_txtTotal.Text		= "";
				m_txtScanData.Text	= "";
			}
		}

		/// <summary>
		/// Displays About dialog.
		/// </summary>
		private void doAbout() 
		{
			AboutForm form = new AboutForm();
			form.ShowDialog(this);
			form.Dispose();
			//form = null;
		}

		/// <summary>
		/// Performs New Sale operation.
		/// </summary>
		private void doNew() 
		{
			int id = m_objSaleBag.generateID();
			m_objCurrentSale = new CashSale( id, DateTime.Today );
			m_objSaleBag.addCashSale( m_objCurrentSale );
			//
			setupEnableControls();
			refreshControls(true);
		}

		/// <summary>
		/// Performs Scan operation.
		/// </summary>
		private void doScan() 
		{
			Random objGenerator = new Random();
			int productIdx = objGenerator.Next(9);
			IProduct objProduct = m_objProducts.getProductAt( productIdx );
			int qty = objGenerator.Next(13);
			if(qty == 0)
				qty = 1;
			SalePosition position = new SalePosition( objProduct, qty );
			m_objCurrentSale.addPosition( position );
			//
			setupEnableControls();
			refreshControls();
		}

		/// <summary>
		/// Performs Total operation.
		/// </summary>
		private void doTotal() 
		{
			m_objCurrentSale.makeTotal();
			setupEnableControls();
			refreshControls(true);
		}

		/// <summary>
		/// Performs Cancel operation.
		/// </summary>
		private void doCancel() 
		{
			//DialogResult result = MessageBox.Show( this, "Abort current sale?", "C# Cash Sale", MessageBox.YesNo|MessageBox.IconQuestion);
			DialogResult result = MessageBox.Show( this, "Abort current sale?", "C# Cash Sale", MessageBoxButtons.YesNo,MessageBoxIcon.Question);
			if(result == DialogResult.Yes)
			{
				m_objSaleBag.removeCashSale( m_objCurrentSale );
				m_objCurrentSale = null;
				//
				setupEnableControls();
				refreshControls();
			}
		}

		/// <summary>
		/// Performs Payment operation.
		/// </summary>
		private void doPayment() 
		{
			PaymentForm form = new PaymentForm(m_objCurrentSale);
			form.ShowDialog(this);
			//
			setupEnableControls();
			refreshControls(true);
		}

		/// <summary>
		/// Performs List All Sales operation.
		/// </summary>
		private void doListSales() 
		{
			CashListForm form = new CashListForm( m_objSaleBag );			
			form.ShowDialog(this);
		}

    }
}
